import React, { useState, useEffect } from 'react'
import { ListGroup } from 'react-bootstrap';
import axios from 'axios'

function ClosedList(props) {

  const [list, setList] = useState([]);

  useEffect(() => {
    getClosedList();
  }, [props.roomCode]);

  async function getClosedList() {
    const userid = sessionStorage.getItem('userId')
    let res = await axios.get('/room/closedlist', { params: { '_id': userid } })
    setList(res.data)
  }

  function enterChatRoomCH(e) {
    if (props.roomCode){
      props.closeChatRoom(props.roomCode)
    }
    const roomCode = e.target.name
    const roomName = e.target.value
    props.enterChatRoom(roomCode)
    props.setRoomCode(roomCode)
    props.setRoomName(roomName)
  }

  return (
    <div>
      {list.map((item, index) =>
        <ListGroup key={index}>
          <ListGroup.Item action onClick={enterChatRoomCH} name={item.roomId} value={item.roomName}>
            {item.roomName}
          </ListGroup.Item>
        </ListGroup>
      )}
    </div>
  )
}

export default ClosedList