import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { Row, Col, Modal, Button, Form, Alert } from 'react-bootstrap';
import Tabs from 'react-bootstrap/Tabs';
import Tab from 'react-bootstrap/Tab';
import ClosedList from '../Components/ClosedList';
import OpenList from '../Components/OpenList';
import Menu from '../Components/Menu';
import catchErrors from '../utils/catchErrors';
import { io } from "socket.io-client";   //모듈 가져오기
import Chat from "../Components/Chat";
import RoomMake from "../Components/RoomMake"
import EnterRoom from "../Components/EnterRoom"

const socket = io();

function Home() {
    const [showModal, setShowModal] = useState(false);
    const [showEnter, setEnter] = useState(false);
    const [chat, setChat] = useState(false);

    //소켓
    const [singleChat, setSingleChat] = useState('')
    const [recievedMsg, setRecievedMsg] = useState('')
    const [roomName, setRoomName] = useState('')
    const [roomCode, setRoomCode] = useState('')

    //방참가
    const [roomId, setRoomId] = useState('')

    const handleCloseModal = () => setShowModal(false);
    const handleShowModal = () => setShowModal(true);
    const handleCloseEnter = () => setEnter(false);
    const handleShowEnter = () => setEnter(true);
    const handleChato = () => setChat(true);
    const handleChatc = () => setChat(false);

    const member = sessionStorage.getItem('userId');

    useEffect(() => {
        const isRoom = Object.values(room).every(el => Boolean(el))
        isRoom ? setDisabled(false) : setDisabled(true)
    }, [room])

    function handleChange(event) {
        const { name, value } = event.target
        setRoom({ ...room, [name]: value, member })
    }

    //SOCKET 관련 시작
    function enterChatroom(rName) {    //방 입장하기
        socket.emit('joinRoom', rName)
        console.log(`joinRoom : ${rName} 입장`)
    }

    const sendMsg = (e) => {
        e.preventDefault()
    }

    useEffect(() => {
        socket.emit("chat", {
            roomName: roomCode,
            msg: singleChat
        })
    }, [singleChat])
    
    
    useEffect(() => {
        socket.on("sendedMSG", (msg) => {
            console.log(msg)
            setRecievedMsg(msg)
        })
    }, [])

    return (
        <>
            <Menu />
            <Row className="mr-0">
                <Col className="list" md={5}>
                    <Tabs defaultActiveKey="closed" id="uncontrolled-tab-example">
                        <Tab eventKey="closed" title="내 채팅" onClick={handleChato} >
                            <ClosedList enterChatroom={enterChatroom} setRoomName={setRoomName} />
                        </Tab>
                        <Tab eventKey="open" title="공개방" >
                            <OpenList enterChatroom={enterChatroom} setRoomName={setRoomName} />
                        </Tab>
                    </Tabs>
                </Col>
                <Col style={{ padding: "0" }}>
                    {chat ? <Chat handleChatc={handleChatc} sendMsg={sendMsg} singleChat={singleChat} recievedMsg={recievedMsg} setSingleChat={setSingleChat} roomName={roomName}/> : null}

                    <div style={{ position: "fixed", bottom: "20px", right: "30px" }}>
                        <Button variant="primary" onClick={handleShowModal} size="lg" block>
                            생성
                        </Button>

                        <Button variant="secondary" onClick={handleShowEnter} size="lg" block>
                            참가
                        </Button>
                    </div>
                </Col>
            </Row>
            <RoomMake showModal={showModal} handleCloseModal={handleCloseModal} />
            <EnterRoom showEnter={showEnter} enterChatRoom={enterChatRoom} handleCloseEnter={handleCloseEnter}/>
        </>
    );
}

export default Home;

