import React, { useState, useEffect } from 'react'
import Menu from '../Components/Menu';
import { Image, Button, Container, Form, Row, Col, Dropdown } from 'react-bootstrap';
import { BrowserRouter as Link } from 'react-router-dom';
import axios from 'axios'

import userdefault from '../Images/KakaoTalk_20201230_153151693.png'
import img1 from '../Images/img_1.png'
import img2 from '../Images/img_2.png'
import img3 from '../Images/img_3.jpg'
import DropdownItem from 'react-bootstrap/esm/DropdownItem';


// const INIT_USER = {
//     username: '',
//     email: '',
//     nickname: ''
// }

function ProfilePage() {
    const [user, setUser] = useState('')

    const [userimg, setUserimg] = useState(img2)
    const [defaultImg, setDefaultImg] = useState(true)
    const [hidden, setHidden] = useState(true)


    async function getLoginedUser() { //email로 db에서 찾아오기 ㅇㅇㅇㅇㅇ
        const userid = sessionStorage.getItem('userId')
        const response = await axios.post(`/users/${userid}`, { 'email': userid })
        setUser(response.data)
    }

    function handleSubmit(e) {
        e.preventDefault()
        if (hidden) {
            setHidden(false)
        } else {
            setHidden(true)
        }
    }
    function handleChange(e) {
        setUser({ ...user, 'nickname': e.target.value })
    }
    async function handleNicksave() {
        const userid = sessionStorage.getItem('userId')
        await axios.put(`/users/${userid}`, user)
    }

    function setThumbnail(event) {  //불러온 사진 <div id='image_container'>에 띄우기
        let reader = new FileReader();

        reader.onload = function (event) {
            let img = document.createElement("img");
            img.setAttribute("src", event.target.result);
            img.setAttribute("id", "profileImg")
            img.setAttribute("style", 'height:300px; width:300px')
            img.setAttribute("class", "mb-3")
            // img.setAttribute("class","d-flex justify-content-center mb-3")
            document.querySelector("div#image_container").appendChild(img);
        };
        reader.readAsDataURL(event.target.files[0]);

        if (defaultImg) {   //첫 이미지 업로드(default이미지 지우고 유저가 올린걸로 업로드)
            let del = document.getElementById("defaultImg")
            del.remove()
            setDefaultImg(false)
        }
        else {  //기존에 올렸던 사진 지우고 재선택한 사진 업로드
            let del2 = document.getElementById('profileImg')
            del2.remove()

            reader.onload = function (event) {
                let img = document.createElement("img");
                img.setAttribute("src", event.target.result);
                img.setAttribute("id", "profileImg")
                img.setAttribute("style", 'height:300px; width:300px')
                document.querySelector("div#image_container").appendChild(img);
            };
        }
    }
    useEffect(() => {
        getLoginedUser()
    }, [])

    return (
        <div>
            <Menu />
            <Container className='border' fluid>
                <Row>
                    <Col sm={4}>
                        <Row className='justify-content-center'>
                            <div className="d-flex ml-3 mt-3" id="defaultImg">
                                <Image src={userimg} width="300px" roundedCircle />
                            </div>
                        </Row>
                        <Row className='ml-3 mt-3 justify-content-center'>
                            <Form className="d-flex">
                                <Form.Group>
                                    <div id="image_container"></div>
                                    <Form.File label="프로필 사진 변경" accept="image/*" onChange={setThumbnail} />
                                </Form.Group>
                            </Form>
                        </Row>
                        <Row className="d-flex justify-content-center mb-3">
                            <Dropdown>
                                <Dropdown.Toggle variant='success' id='dropdown-basic'>
                                    프로필 사진 선택
                                </Dropdown.Toggle>
                                <Dropdown.Menu>
                                    <Dropdown.Item as='button'>홈으로</Dropdown.Item>
                                    <Dropdown.Item href='/'>라이언</Dropdown.Item>
                                    <Dropdown.Item href='/'>어피치</Dropdown.Item>
                                </Dropdown.Menu>
                            </Dropdown>
                        </Row>
                    </Col>
                    <Col sm={8}>
                        <Row className='m-5 justify-content-center'>
                            <h2>{user.username}님의 프로필 정보</h2>
                        </Row>
                        <Row className="m-3 justify-content-flex-start" style={{ fontWeight: "bold", fontSize: "large" }}>
                            <Col xs={3}>이름 :</Col>
                            <Col xs={6}>{user.username}</Col>
                            {/* <Col sm={4}></Col> */}
                        </Row>
                        <Row className="m-3 justify-content-flex-start" id="nickname" style={{ fontWeight: "bold", fontSize: "large" }}>
                            <Col xs={3}>별명 :</Col>
                            <Col xs={6} hidden={!hidden}>
                                {user.nickname}
                            </Col>
                            <Col xs={6} hidden={hidden}>
                                <Form>
                                    <Form.Control defaultValue={user.nickname} style={{ width: "110%" }} onChange={handleChange} />
                                </Form>
                            </Col>
                            <Col xs={3}>
                                <Form className="d-flex" onSubmit={handleSubmit}>
                                    <Button className="ml-3 d-flex justify-content-end" variant="outline-primary" size="sm" type='submit'>수정</Button>
                                </Form>
                            </Col>
                        </Row>
                        <Row className="m-3" style={{ fontWeight: "bold", fontSize: "large" }}>
                            <Col xs={3}>이메일 : </Col>
                            <Col xs={6}>{user.email}</Col>
                        </Row>
                        <Row className='m-3 justify-content-center'>
                            <Form>
                                <Button variant="outline-success" size="sm" className="mr-4" onClick={handleNicksave}>저장</Button>
                                <Link to='/'>
                                    <Button variant="outline-success" size="sm" className="ml-4" >홈 화면으로</Button>
                                </Link>
                            </Form>
                        </Row>
                    </Col>
                </Row>
            </Container>
        </div>
    )
}

export default ProfilePage
