import mongoose from 'mongoose'

const { String } = mongoose.Schema.Types

const ChatSchema = new mongoose.Schema({
    room: {
        type: mongoose.ObjectId,
        required: true,
        ref: 'Room',
    },
    username: {
        type: String,
        required: true,
    },
    message: {
        type: String,
        required: true
    },
    profileimg :{
        type: String,
        default: '3cd14b9bcb2007f324fcb82e0b566cce'
    }
}, {
    timestamps: true
})

export default mongoose.models.Chat || mongoose.model('Chat', ChatSchema)