import React from 'react';
import ReactDOM from 'react-dom';
import 'bootstrap/dist/css/bootstrap.min.css';
import './index.css';
import { BrowserRouter as Router, Route, Switch } from 'react-router-dom';
import reportWebVitals from './reportWebVitals';
import SignUpPage from './Pages/SignUpPage';
import ProfilePage from './Pages/ProfilePage';
import 'bootstrap/dist/css/bootstrap.min.css';
import LogInPage from './Pages/LogInPage';
import HomePage from './Pages/HomePage'
import PrivateRoute from './Components/PrivateRoute';

ReactDOM.render(
  <Router>
    <Switch>
      <PrivateRoute exact path="/">
        <HomePage />
      </PrivateRoute>
      <Route path="/home" component={HomePage} />
      <Route path="/login" component={LogInPage} />
      <Route path="/signup" component={SignUpPage} />
      <Route path="/profile" component={ProfilePage} />
      <PrivateRoute path="/profile">
        <ProfilePage />
      </PrivateRoute>

    </Switch>
  </Router>,
  document.getElementById('root')
);

// If you want to start measuring performance in your app, pass a function
// to log results (for example: reportWebVitals(console.log))
// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals
reportWebVitals();
