import React, { useState, useEffect } from 'react'
import { ListGroup } from 'react-bootstrap';
import axios from 'axios'

function OpenList(props) {
  const [openlist, setOpenlist] = useState([]);

  useEffect(() => {
    getOpenList();
  }, []);

  async function getOpenList() {
    let res = await axios.get('/room/openlist')
    console.log('가져온거o', res)
    setOpenlist(res.data)
  }


  function enterChatRoomCH(e) {
    const roomName = e.target.name
    props.enterChatRoom(roomName) // 각각의 room으로 들어가도록 설정해야 함
    props.setRoomName(roomName)
    // props.clearChat()
  }

  return (
    <div>
      {openlist.map((item, index) =>
        <ListGroup key={index}>
          <ListGroup.Item action onClick={enterChatroomCH} name={item.roomName}>
            {item.roomName}
          </ListGroup.Item>
        </ListGroup>
      )}
    </div>
  )
}

export default OpenList
