import mongoose from 'mongoose'

const {String} = mongoose.Schema.Types

const ChatSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true,
    },
    interest: {
        type: String,
        required: true,
        select: false
    },
    isOpen: {
        type: Boolean,
        required: true,
    }
}, {
    timestamps: true
})

export default mongoose.models.chat || mongoose.model('chat', ChatSchema)