import chat from "../models/chat.js"
import isLength from 'validator/lib/isLength.js'

const makeChat = async (req, res) => {
    const {name, interest, isOpen} = req.body;
    // console.log('/bodyCheck', interest);
    try {
        if (!isLength(name, { min: 3, max: 10 })) {
            return res.status(422).json({message: 'Name must be 3-10 characters'})
        }
        const newChat = await new chat({
            name,
            interest,
            isOpen
        }).save()
        console.log(newChat)
        res.json(newChat)
    } catch (error) {
        console.log(error)
        res.status(500).json({message: 'User signup error'})
    }
}

const hello = (req, res) => {
    res.send('Hello from users controller')
}

export default { makeChat, hello }