import React, { useState } from 'react';
import { Button, Form, Container, Navbar } from 'react-bootstrap';
import { Link } from 'react-router-dom';
import Menu from '../Components/Menu';

function SingUp() {
    const [validated, setValidated] = useState(false);

    const handleSubmit = (event) => {
        const form = event.currentTarget;
        if (form.checkValidity() === false) {
            event.preventDefault();
            event.stopPropagation();
        }

        setValidated(true);
    };

    return (
        <>
            <Menu />

            <div>
                <Form noValidate validated={validated} onSubmit={handleSubmit}>
                    <Container className="d-flex justify-content-center">
                        <div className="mt-5 p-5 shadow w-75">

                            <h2 className="text-center ">회원가입</h2>

                            <Form.Group controlId="formGroupUsername">
                                <Form.Label>이름</Form.Label>
                                <Form.Control
                                    required
                                    type="text"
                                    placeholder="이름을 입력해주세요" />
                                <Form.Control.Feedback type="invalid">
                                    필수 정보입니다! 이름을 입력해주세요!
                            </Form.Control.Feedback>
                            </Form.Group>

                            <Form.Group controlId="formGroupNickname">
                                <Form.Label>별명</Form.Label>
                                <Form.Control
                                    required
                                    type="text"
                                    placeholder="별명을 입력해주세요" />
                                <Form.Control.Feedback type="invalid">
                                    필수 정보입니다! 별명을 입력해주세요!
                            </Form.Control.Feedback>
                            </Form.Group>

                            <Form.Group controlId="formGroupEmail">
                                <Form.Label>이메일</Form.Label>
                                <Form.Control
                                    required
                                    type="text"
                                    placeholder="이메일을 입력해주세요" />
                                <Form.Control.Feedback type="invalid">
                                    필수 정보입니다! 이메일을 입력해주세요!
                        </Form.Control.Feedback>
                            </Form.Group>

                            <Form.Group controlId="formGroupPassword">
                                <Form.Label>비밀번호</Form.Label>
                                <Form.Control
                                    required
                                    type="text"
                                    placeholder="비밀번호를 입력해주세요" />
                                <Form.Control.Feedback type="invalid">
                                    필수 정보입니다! 비밀번호를 입력해주세요!
                            </Form.Control.Feedback>
                            </Form.Group>

                            <Link to="./">
                                <Button type="submit" variant="outline-success" size="lg" className="mr-4" block>가입</Button>
                            </Link>
                        </div>
                    </Container>
                </Form>
            </div >
        </>
    )
}

export default SingUp