import React, { useState } from 'react';
import { ListGroup, Col, Row, Modal, Button, Form, Alert } from 'react-bootstrap';
import 'bootstrap/dist/css/bootstrap.min.css';
import randCode from '../randCode'
// import randomN from './RandomN';

function Home() {
    const [list, setList] = useState([
        { room: '테스트 방1', memnum: 5, admin: '가영' },
        { room: '테스트 방2', memnum: 4, admin: '수현' }]
    );

    const [show, setShow] = useState(false);

    const handleClose = () => setShow(false);
    const handleShow = () => setShow(true);

    const [show2, setShow2] = useState(false);

    const handleClose2 = () => setShow2(false);
    const handleShow2 = () => setShow2(true);

    const [checkedI, setCheckedI] = useState(false);

    const codeClose = () => setCheckedI(false);
    const codeShow = () => setCheckedI(true);

    const [showCode, setCode] = useState(false);

    const handleCloseCode = () => setCode(false);
    const handleShowCode = () => setCode(true);


    return (
        <div className="container">
            <div className="list">
                <Col md={6}>
                    {list.map(list =>
                        <ListGroup>
                            <ListGroup.Item action>
                                <h2>{list.room}</h2>
                                <p></p>
                            </ListGroup.Item>
                        </ListGroup>
                    )}
                </Col>
            </div>
            <div className="right">
                <button variant="primary" onClick={handleShow}>
                    생성
                </button>

                <button variant="primary" onClick={handleShow2}>
                    참가
                </button>

                <Modal show={show} onHide={handleClose}>
                    <Modal.Header closeButton>
                        <Modal.Title>방 생성</Modal.Title>
                    </Modal.Header>
                    <Modal.Body>
                        <Form onSubmit = {handleShowCode}>
                            <Form.Group as={Row} controlId="formChatTitle">
                                <Form.Label column sm={4}>방 이름</Form.Label>
                                <Col>
                                    <Form.Control type="text" />
                                </Col>
                            </Form.Group>
                            <Form.Group as={Row} controlId="formInterest">
                                <Form.Label column sm={4}>관심 분야</Form.Label>
                                <Col>
                                    <Form.Control as="select" defaultValue="Choose...">
                                        <option>Choose...</option>
                                        <option>과학</option>
                                        <option>수학</option>
                                        <option>예술</option>
                                        <option>언어</option>
                                        <option>취미</option>
                                    </Form.Control>
                                </Col>
                            </Form.Group>
                            <Form.Group as={Row} controlId="formBasicCheckbox">
                                <Form.Label column sm={4}>공개방</Form.Label>
                                <Col>
                                    <Form.Check
                                        type="checkbox"
                                        checked={checkedI}
                                        onChange={() => setCheckedI(!checkedI)} />
                                </Col>
                            </Form.Group>
                            {
                                (checkedI)
                                    ? (<p><b>공개방</b>으로 개설되어 공개방 목록에 공개되며, 코드를 공유하여 참가할 수도 있습니다.</p>)
                                    : (<p><b>비밀방</b>으로 개설되며, 참여자들에게 코드를 공유해야합니다.</p>)
                            }
                            <Form.Group as={Row}>
                                <Col sm={{ span: 5, offset: 4 }}>
                                    <Button type="submit" >방 생성</Button>
                                </Col>
                            </Form.Group>
                        </Form>
                    </Modal.Body>
                </Modal>

                {(showCode)? (alert('참여코드'), setCode(false)):null}

                <Modal show={show2} onHide={handleClose2}>
                    <Modal.Header closeButton>
                        <Modal.Title>참여 코드로 채팅 참가</Modal.Title>
                    </Modal.Header>
                    <Modal.Body>
                        <Form onSubmit={() => { console.log('제출') }}>
                            <Form.Group as={Row} controlId="formCodeE">
                                <Form.Label column sm={4}>참여 코드</Form.Label>
                                <Col>
                                    <Form.Control type="text" />
                                </Col>
                            </Form.Group>
                            <Form.Group as={Row}>
                                <Col sm={{ span: 5, offset: 4 }}>
                                    <Button type="submit">참가</Button>
                                </Col>
                            </Form.Group>
                        </Form>
                    </Modal.Body>
                </Modal>
            </div>
        </div >
    );
}

export default Home;