import React, { useState } from 'react';
import { Row, Col, Modal, Button, Navbar, Nav } from 'react-bootstrap';
import Tabs from 'react-bootstrap/Tabs';
import Tab from 'react-bootstrap/Tab';
import ClosedList from '../Components/ClosedList';
import OpenList from '../Components/OpenList';
import Chat from '../Components/Chat';
// import styled from 'styled-components';

// const List = styled.div`
//   background: #FFFAFA;
// `
const userName = "정연우";


function Home() {
  const [show, setShow] = useState(false);
  const [chat, setChat] = useState(false);

  const handleClose = () => setShow(false);
  const handleShow = () => setShow(true);
  const handleChato = () => setChat(true);
  const handleChatc = () => setChat(false);
  // variant="pills"

  return (
    <>
      <Navbar bg="dark" variant="dark">
        <Navbar.Brand href="/homepage">YDK Messenger</Navbar.Brand>
        <div className='ml-1 mr-2' style={{ color: 'white' }}>{userName} 님 환영합니다</div>
        <Nav className="mr-auto">
          <Nav.Link href="/homepage">Home</Nav.Link>
          <Nav.Link href="/profilepage">Profile</Nav.Link>
          <Nav.Link href="/hello">Hello</Nav.Link>
        </Nav>
        {/* <Form inline>
                    <FormControl type="text" placeholder="Search" className="mr-sm-2" />
                    <Button variant="outline-info">Search</Button>
                </Form> */}
        <Button variant="light" className="ml-3">Logout</Button>
      </Navbar>
      <Row className="mr-0">
        <Col className="list" md={5}>
          <Tabs defaultActiveKey="closed" id="uncontrolled-tab-example">
            <Tab eventKey="closed" title="내 채팅" onClick={handleChato} >
              <ClosedList />
            </Tab>
            <Tab eventKey="open" title="공개방" >
              <OpenList />
            </Tab>
          </Tabs>
        </Col>
        <Col style={{ padding: "0" }}>
          {chat ? <Chat handleChatc={handleChatc} /> : null}

          <Button variant="primary" onClick={handleShow} style={{ position: "fixed", bottom: "10px", right: "10px" }} >
            생성
        </Button>

          <Modal show={show} onHide={handleClose}>
            <Modal.Header closeButton>
              <Modal.Title>방 생성</Modal.Title>
            </Modal.Header>
            <Modal.Body>여기에 form 입력</Modal.Body>
            <Modal.Footer>
              <Button variant="primary" onClick={handleClose}>
                생성
            </Button>
            </Modal.Footer>
          </Modal>
        </Col>
      </Row>
    </>
  );
}

export default Home;
