import React, { useState } from 'react'
import { ListGroup } from 'react-bootstrap';

function OpenList(props) {
  const [list, setList] = useState([
    { room: '테스트 방3', memnum: 7, admin: '가영2' },
    { room: '테스트 방4', memnum: 2, admin: '수현2' }]
  );

  function enterChatroomCH(e) {
    const roomName = e.target.name
    props.enterChatroom(roomName) // 각각의 room으로 들어가도록 설정해야 함
    props.setRoomName(roomName)
    // props.clearChat()
  }

  return (
    <div>
      {list.map((list, index) =>
        <ListGroup key={index}>
          <ListGroup.Item action onClick={enterChatroomCH} name={list.room}>
            <h2>{list.room}</h2>
          </ListGroup.Item>
        </ListGroup>
      )}
    </div>
  )
}

export default OpenList
