import React, { useState, useEffect } from 'react';
import { Row, Col, Modal, Button, Navbar, Nav } from 'react-bootstrap';
import Tabs from 'react-bootstrap/Tabs';
import Tab from 'react-bootstrap/Tab';
import ClosedList from '../Components/ClosedList';
import OpenList from '../Components/OpenList';
import Chat from '../Components/Chat';
import Menu from '../Components/Menu';
// import styled from 'styled-components';
import { io } from "socket.io-client";   //모듈 가져오기

// const List = styled.div`
//   background: #FFFAFA;
// `
const userName = "정연우";

const socket = io();


function Home() {
  const [show, setShow] = useState(false);
  const [chat, setChat] = useState(false);

  const handleClose = () => setShow(false);
  const handleShow = () => setShow(true);
  const handleChato = () => setChat(true);
  const handleChatc = () => setChat(false);
  // variant="pills"

  ///////////////////////////////////////////////////////////////
  const [inner, setInner] = useState([''])
  console.log('sendMsg2222', inner)
  const [chatmsg, setChatmsg] = useState([inner])
  const [roomName, setRoomName] = useState('dd')   //방 선택이 방1을 눌럿다 방2를 누르면 전체로 전송됨

  function enterChatroom(roomName) {    //방 입장하기
    socket.emit('joinRoom', roomName)
    console.log(`joinRoom : ${roomName} 입장`)
  }

  const sendMsg = (e) => {
    e.preventDefault()
    console.log('sendMsg', inner)
    console.log(roomName)
    socket.emit("chat", {
      roomName: roomName,
      msg: inner
    });
  }

  function clearChat() {
    setChatmsg([])
  }

  useEffect(() => {
    console.log('useeffect1')
    socket.on('broadcast', (msg) => {

      console.log('msg', msg)
      console.log('inner :', inner)

      setChatmsg([...chatmsg, msg])
      console.log('useeffect2', chatmsg)
    })
    console.log('useeffect2', chatmsg)
  }, [chatmsg])
  //////////////////////////////////////////////////////////








  return (
    <>
      <Menu />
      <Row className="mr-0">
        <Col className="list" md={5}>
          <Tabs defaultActiveKey="closed" id="uncontrolled-tab-example">
            <Tab eventKey="closed" title="내 채팅" onClick={handleChato} >
              <ClosedList enterChatroom={enterChatroom} setRoomName={setRoomName} clearChat={clearChat} />
            </Tab>
            <Tab eventKey="open" title="공개방" >
              <OpenList />
            </Tab>
          </Tabs>
        </Col>
        <Col style={{ padding: "0" }}>
          {chat ? <Chat handleChatc={handleChatc} sendMsg={sendMsg} setInner={setInner} chatmsg={chatmsg} roomName={roomName} /> : null}

          <Button variant="primary" onClick={handleShow} style={{ position: "fixed", bottom: "10px", right: "10px" }} >
            생성
        </Button>

          <Modal show={show} onHide={handleClose}>
            <Modal.Header closeButton>
              <Modal.Title>방 생성</Modal.Title>
            </Modal.Header>
            <Modal.Body>여기에 form 입력</Modal.Body>
            <Modal.Footer>
              <Button variant="primary" onClick={handleClose}>
                생성
            </Button>
            </Modal.Footer>
          </Modal>
        </Col>
      </Row>
    </>
  );
}

export default Home;
