import React, { useState } from 'react';
import { ListGroup, Col, Row, Modal, Button, Form } from 'react-bootstrap';
import 'bootstrap/dist/css/bootstrap.min.css';
// import Form from 'react-bootstrap';


function Home() {
    const [list, setList] = useState([
        { room: '테스트 방1', memnum: 5, admin: '가영' },
        { room: '테스트 방2', memnum: 4, admin: '수현' }]
    );

    const [show, setShow] = useState(false);

    const handleClose = () => setShow(false);
    const handleShow = () => setShow(true);


    return (
        <div className="container">
            <div className="list">
                <Col md={6}>
                    {list.map(list =>
                        <ListGroup>
                            <ListGroup.Item action>
                                <h2>{list.room}</h2>
                                <p></p>
                            </ListGroup.Item>
                        </ListGroup>
                    )}
                </Col>
            </div>
            <div className="right">
                <button variant="primary" onClick={handleShow}>
                    생성
                </button>

                <Modal show={show} onHide={handleClose}>
                    <Modal.Header closeButton>
                        <Modal.Title>방 생성</Modal.Title>
                    </Modal.Header>
                    <Modal.Body>
                        <Form onSubmit={() => { console.log('제출') }}>
                            <Form.Group as={Row} controlId="formChatTitle">
                                <Form.Label column sm={4}>방 이름</Form.Label>
                                <Col>
                                    <Form.Control type="text" placeholder="" />
                                </Col>
                            </Form.Group>
                            <Form.Group as={Row} controlId="formInterest">
                                <Form.Label column sm={4}>관심 분야</Form.Label>
                                <Col>
                                    <Form.Control as="select" defaultValue="Choose...">
                                        <option>Choose...</option>
                                        <option>과학</option>
                                        <option>수학</option>
                                        <option>예술</option>
                                        <option>언어</option>
                                        <option>취미</option>
                                    </Form.Control>
                                </Col>
                            </Form.Group>
                            <Form.Group as={Row} controlId="formBasicCheckbox">
                                <Form.Label column sm={4}>공개방</Form.Label>
                                <Col>
                                    <Form.Check type="checkbox" onClick={handleShow}/>
                                </Col>
                            </Form.Group>
                            <Form.Group as={Row}>
                                <Col sm={{ span: 5, offset: 4 }}>
                                    <Button type="submit">방 생성</Button>
                                </Col>
                            </Form.Group>
                        </Form>
                    </Modal.Body>
                </Modal>

            </div>
        </div>
    );
}

export default Home;