import React, { useState, useEffect } from 'react'
import { ListGroup } from 'react-bootstrap';
import axios from 'axios'

function OpenList(props) {
  const [list, setList] = useState([]);

  useEffect(() => {
    getOpenList();
  }, []);

  async function getOpenList() {
    let res = await axios.get('/room/openlist')
    console.log('가져온거', res)
    setList(res.data)
  }


  function enterChatroomCH(e) {
    console.log(e.target.name)
    console.log(e.target)
    const roomName = e.target.name
    props.enterChatroom(roomName) // 각각의 room으로 들어가도록 설정해야 함
    props.setRoomName(roomName)
    // props.clearChat()
  }

  //user.hasOwnProperty('이름');

  return (
    <div>
      {list.map((item, index) =>
        <ListGroup key={index}>
          <ListGroup.Item action onClick={enterChatroomCH} name={list.roomName}>
            {list.roomName}
          </ListGroup.Item>
        </ListGroup>
      )}
    </div>
  )
}

export default OpenList
