import mongoose from 'mongoose'

const {String} = mongoose.Schema.Types

const RoomSchema = new mongoose.Schema({
    roomId: {
        type: String,
        // default:() => nanoid(),
        unique: true
    },
    roomName: {
        type: String,
        required: true,
    },
    interest: {
        type: String,
        required: true,
        select: false
    },
    isOpen: {
        type: Boolean,
        required: true,
    }
}, {
    timestamps: true
})

export default mongoose.models.Room || mongoose.model('Room', RoomSchema)
