import mongoose from 'mongoose'

const { String } = mongoose.Schema.Types

const ChatSchema = new mongoose.Schema({
    room: {
        type: ObjectId,
        required: true,
        ref: 'Room',
    },
    username: {
        type: String,
        required: true,
        ref: 'User',
    },
    message: String,
}, {
    timestamps: true
})

export default mongoose.models.Chat || mongoose.model('Chat', ChatSchema)