import express from 'express'
import connectDb from './utils/connectDb.js'
import userRouter from './routes/user.routes.js'
import authRouter from './routes/auth.routes.js'

connectDb()

const app = express()

app.use(express.json())
//이부분을 body 파싱함
//express가 req.body라는곳을 자동으로만들어서 json형식으로 보낸것을 객체형식으로 넣음
//이부분 다음부터는 req.body라는 부분을 실행할 수 있음

app.use(userRouter)
app.use(authRouter)
//userRouter로 이동

app.get('/', (req, res) => {
    res.send('Hello World. 안녕하세요')
})

app.listen(3030, () => {
    console.log('Listening on port 3030')
})
