import User from "../models/User.js"
import isLength from 'validator/lib/isLength.js'
import isEmail from 'validator/lib/isEmail.js'
import bcrypt from "bcryptjs";


const signup = async (req, res) => {

    const { username, nickname, email, password } = req.body

    try {
        if (!isLength(username, { min: 3, max: 10 })) {
            return res.status(422).send('이름은 3-10자 사이입니다')
        } else if (!isLength(nickname, { min: 2, max: 10 })) {
            return res.status(422).send('별명은 2-10자 사이입니다.')
        } else if (!isLength(password, { min: 6 })) {
            return res.status(422).send('비밀번호는 6자 이상입니다.')
        } else if (!isEmail(email)) {
            return res.status(422).send('유효하지 않은 이메일 형식입니다')
        }

        const user = await User.findOne({ email })
        if (user) {
            return res.status(422).send(`${email}이 이미 사용중입니다.`)
        }

        const hash = await bcrypt.hash(password, 10)

        const newUser = await new User({
            username,
            nickname,
            email,
            password: hash,
        }).save()

        console.log(newUser)
        res.json(newUser)

    } catch (error) {
        //알수없는 모든 에러발생시 처리
        console.log(error)
        res.status(500).send('회원가입 에러발생하였습니다.')
    }
}

const logineduser = async (req, res) => {
    try {
        let user = await User.findOne(req.body).select('username email nickname').exec()
        return res.json(user)
    } catch (error) {
        alert('올바르지 못한 접근입니다.')
    }
}

const changenick = async (req, res) => {
    try {
        const newnick = req.body.nickname
        await User.updateOne({ 'username': req.body.username }, { 'nickname': newnick })
    } catch (error) {
        alert('올바르지 못한 접근입니다.')
    }
}

const loginNavbar = async (req, res) => {
    try {
        let user = await User.findOne(req.body).select('username').exec()
        return res.json(user)
    } catch (error) {
        alert('올바르지 못한 접근입니다.')
    }
}

export default { signup, logineduser, changenick, loginNavbar }
// {} : 객체로 return 함
