import Room from "../models/Room.js"
import Chat from "../models/Chat.js";
import User from "../models/User.js";
import EntryLog from "../models/EntryLog.js";

const roomEnter = async (req, res) => {
    const roomId = req.body.enterCode

    try {
        const room = await Room.findOne({ roomId })
        if (!room) {
            return res.status(404).send(`참여코드가 존재하지 않습니다.`)
        }
        console.log('roomId존재')
        const name = await Room.findOne({ roomId: roomId }).select('roomName')
        return res.json(name.roomName)

    } catch (error) {
        //알수없는 모든 에러발생시 처리
        console.log(error)
        res.status(500).send('방 참여 에러')
    }
}

const getChatInfo = async (req, res) => {
    const roomId = req.query.roomCode
    try {
        const room_id = await Room.find({ roomId: roomId }).select('_id')  //roomId로 해당 방의 _id를 찾아옴
        let infolist = await Chat.find({ room: room_id }).select('message username createdAt profileimg')
        res.json(infolist)
    } catch (error) {
        res.status(500).send('이전 채팅 정보 불러오기를 실패하였습니다!')
    }
}


//그사람의 그방에서의 기록이 있는지 확인
const checklog = async (req, res) => {
    console.log('@@@@@서버에서 체크 로그')
    const { userId, roomCode } = req.query
    const roomId = await Room.findOne({ roomId: roomCode })
    try {
        const entrylog = await EntryLog.findOne({ userId: userId, room: roomId })
        res.json(Boolean(entrylog))
    } catch (error) {
        res.json(false)
    }
}

//출입기록 업로드
const uploadlog = async (req, res) => {
    console.log('@@@@@서버에서 업로드 로그')
    const { userId, leaveTime, roomCode } = req.body
    const user = await User.findOne({ _id: userId })    // 받아온 _id로 그 유저의 정보 가져옴
    const room = await Room.findOne({ roomId: roomCode })   // 받아온 roomCode로 그 방의 정보 가져옴
    try {
        const entrylog = await new EntryLog({
            userId: user._id,
            room: room._id,
            leaveTime: leaveTime,
        }).save()
        res.json(entrylog)
    } catch (error) {
        console.log(error)
        res.send(500).send('출입시간이 기록되지 않았습니다.')
    }
}

//출입기록 수정
const updatelog = async (req, res) => {
    console.log('@@@@@서버에서 업데이트 로그')
    const { userId, leaveTime, roomCode } = req.body
    console.log('@@@@@', leaveTime, userId, roomCode)
    const room = await Room.findOne({ roomId: roomCode })
    try {
        await EntryLog.updateOne({ userId: userId, room: room._id }, { leaveTime: leaveTime })  //항상 id와 room이 둘다 맞는걸 수정해야함 !
        res.send('finished')
    } catch (error) {
        console.log(error)
        res.send(500).send('출입시간 업데이트 실패')
    }

}


export default { roomEnter, getChatInfo, checklog, uploadlog, updatelog }