import React, { useState } from "react";
import Joi, { validate } from "joi-browser";

const LoginForm = () => {
  const userSchema = {
    username: Joi.string().required(),
    password: Joi.string().required(),
  };

  const [userInfo, setUserInfo] = useState({
    username: "",
    password: "",
  });

  const handleSubmit = (e) => {
    e.preventDefault(); // 기본 동작 방지
  };

  const handleChange = (e) => {
    // e.target.id: 변경이 일어난 input 태그의 id
    // e.target.value: 변경이 일어난 input 태그의 값
    const { id, value } = e.target;
    const errors = { ...userInfo.errors };

    /* 입력받은 값 유효성 검증 */
    const obj = { [id]: value }; // 입력받은 값에 
    const schema = { [id]: userSchema[id] }; // Joi 스키마를 적용하여
    const { error } = validate(obj, schema); // 유효성 검증

    if(error) errors[id] = error;
    else delete errors[id];

    /* 입력받은 username 및 password를 state에 저장 */
    const data = userInfo;
    data[id] = value; // 점(.) 표기법을 대괄호([]) 표기법으로 사용
    setUserInfo({ ...data, errors });
  };

  const buttonValidate = () => {
    const options = { abortEarly: false, allowUnknown:true };
    const { error } = Joi.validate(userInfo, userSchema, options);

    // 에러 미발생 시 null 반환
    if (!error) return null;

    // 에러 발생 시 에러 정보 반환
    const errors = {};
    for (let item of error.details) {
      errors[item.path[0]] = item.message;
    }
    return errors;
  }

  const handleClick = (e) => {
    e.preventDefault();
    const validUsername = 'ingyeo';
    const validPassword = '1234';

    if(validUsername === userInfo.username && validPassword === userInfo.password)
      alert('로그인 성공!')
    else 
      alert('로그인 실패...');
  }

  return (
    <div>
      <h1>Login</h1>
      <form onSubmit={handleSubmit}>
        <div className="form-group">
          <label htmlFor="username">Username</label>{" "}
          {/* 이 label 태그는 아래 input 태그를 참조함  */}
          <input
            onChange={handleChange}
            id="username"
            type="text"
            className="form-control"
          />
        </div>
        <div className="form-group">
          <label htmlFor="password">Password</label>
          <input
            onChange={handleChange}
            id="password"
            type="password"
            className="form-control"
          />
        </div>
        <button 
          disabled={buttonValidate()}
          onClick={handleClick}
          className="btn btn-primary">Login</button>
      </form>
    </div>
  );
};

export default LoginForm;