import express from 'express'
import connectDb from './utils/connectDb.js'
import userRouter from './routes/user.routes.js'
import authRouter from './routes/auth.routes.js'
import roomRouter from './routes/room.routers.js'
import roomEnterRouter from './routes/roomEnter.routers.js'
import bodyParser from "body-parser";
import http from "http";
import { Server } from 'socket.io';
import cors from "cors"
import Room from './models/Room.js'
import Chat from "./models/Chat.js"

connectDb()

const app = express()

const server = http.createServer(app);

const io = new Server(server)

io.on("connection", (socket) => { // 기본 연결
  console.log("socket connect ok", socket.id)

  socket.on('joinRoom', (data) => { // joinRoom을 클라이언트가 emit했을 때
    console.log('join_data확인', data)
    let roomInfo = data;
    socket.join(roomInfo); //클라이언트에서 data에 적힌 room으로 참여시킴
  });

  socket.on('closeRoom', (data) => {
    console.log('close_data확인', data)
    let roomInfo = data;
    socket.leave(roomInfo); //클라이언트에서 data에 적힌 room정보를 브로드캐스팅 받지 않는다.
  });
  
  socket.on('chat', async (data) => {
    console.log('roomname확인', data)
    const room = await Room.findOne({ roomId: data.roomInfo })
    console.log('room이 떴나', room)

    const chat = await new Chat({
      room: room._id,
      username: data.sendInfo.sender,
      message: data.sendInfo.msg,
      profileimg: data.sendInfo.img
    }).save()
    console.log('resChat확인', chat)

    socket.broadcast.to(data.roomInfo).emit('sendedMSG', data.sendInfo); // sender 제외 특정 방으로

  }); 

  socket.on('disconnect', () => {
    console.log('disconnected from server id=', socket.id)
  })
});

app.use(bodyParser.json());
app.use(cors());

app.use('/images', express.static('uploads/'))
app.use(userRouter)
app.use(authRouter)
app.use(roomRouter)
app.use(roomEnterRouter)

server.listen(3030, () => {
  console.log('Listening on port 3030')
})

export default server
// module.exports = server;
