//주고받는 형식을 정의함.

import mongoose from 'mongoose'

const { String } = mongoose.Schema.Types
const { Array } = mongoose.Schema.Types
//원래 java의 string이 아니라 mongoose의 string을 쓰기 위해 불러옴.
//object의 id를 쓸때에도 추가시켜줘야됨.

//형식을 정의함.
const UserSchema = new mongoose.Schema({
    username: {
        type: String,
        required: true,
    },
    nickname: {
        type: String,
        required: true,
    },
    email: {
        type: String,
        required: true,
        unique: true,
        //unique: 같은 email을 두번넣으면 error발생함
    },
    password: {
        type: String,
        required: true,
        select: false,
        //정보를 찾을때 찾지 않게함
        //플러스 옵션을 주면 찾을 수 있음(mongoose에서 용법찾아봐야됨)
    },
    profileimg: {
        type: String,
        default: '3cd14b9bcb2007f324fcb82e0b566cce',
    },
}, {
   
    timestamps: true
   
})

export default mongoose.models.User || mongoose.model('User', UserSchema)

