import React, { useState } from 'react';
import ReactDOM from 'react-dom';

import { Image, Button, Container, Form, FormControl, Navbar, Nav } from 'react-bootstrap';
import { BrowserRouter as Router, Route, Redirect, Switch, Link } from 'react-router-dom';

import userdefault from './KakaoTalk_20201230_153151693.png'


const userName = "정연우";
const userEmail = "dusdn8455@korea.ac.kr";
let userNickname = "가나다라마바사";



function editNickname1() {  //수정버튼 누르면 재입력하게 함
    const html = (
        <Form>
            <div className="d-flex justify-content-center">
                별명 : <Form.Control className="" id="editBlock" style={{ width: "40%" }} size="sm" type="id" defaultValue={userNickname} />
                <Button className="ml-3" variant="outline-primary" size="sm" onClick={editNickname2}>수정</Button>
            </div>
            {/* 
            <div>
                <Image src={pic} width="300px" roundedCircle />

            </div> */}
        </Form>
    )
    ReactDOM.render(html, document.getElementById("nickname"))
}
function editNickname2() {   //수정버튼 누르면 다시 원래대로 돌아가게 함
    changeNickname()
    const html = (
        <div>
            별명 : {userNickname}
            <Button className="ml-3" variant="outline-primary" size="sm" onClick={editNickname1}>수정</Button>
        </div>
    )
    ReactDOM.render(html, document.getElementById("nickname"))
}
function changeNickname() {  //수정버튼 누르면 닉네임 변경해줌
    let editedNickname = document.getElementById("editBlock")
    userNickname = editedNickname.value
}

function ProfilePage() {
    const [tohome, setTohome] = useState(false)
    const [defaultImg, setDefaultImg] = useState(true)

    function goHome() {
        return (setTohome(true))
    }

    function setThumbnail(event) {  //불러온 사진 <div id='image_container'>에 띄우기
        let reader = new FileReader();

        reader.onload = function (event) {
            let img = document.createElement("img");
            img.setAttribute("src", event.target.result);
            img.setAttribute("id", "profileImg")
            img.setAttribute("style",'height:300px; width:300px')
            img.setAttribute("class","mb-3")
            // img.setAttribute("class","d-flex justify-content-center mb-3")
            document.querySelector("div#image_container").appendChild(img);
        };
        reader.readAsDataURL(event.target.files[0]);


        if (defaultImg) {   //첫 이미지 업로드(default이미지 지우고 유저가 올린걸로 업로드)
            let del = document.getElementById("defaultImg")
            del.remove()
            setDefaultImg(false)
        }
        else {  //기존에 올렸던 사진 지우고 재선택한 사진 업로드
            let del2= document.getElementById('profileImg')
            del2.remove()

            reader.onload = function (event) {
                let img = document.createElement("img");
                img.setAttribute("src", event.target.result);
                img.setAttribute("id", "profileImg")
                img.setAttribute("style",'height:300px; width:300px')
                document.querySelector("div#image_container").appendChild(img);
            };
        }
    }


    return (
        <div>
            <Navbar bg="dark" variant="dark">
                <Navbar.Brand href="/homepage">YDK Messenger</Navbar.Brand>
                <div className='ml-1 mr-2' style={{ color: 'white' }}>{userName} 님 환영합니다</div>
                <Nav className="mr-auto">
                    <Nav.Link href="/homepage">Home</Nav.Link>
                    <Nav.Link href="/profilepage">Profile</Nav.Link>
                    <Nav.Link href="/hello">Hello</Nav.Link>
                </Nav>
                <Button variant="light" className="ml-3">Logout</Button>
            </Navbar>

            {tohome ? <Redirect to='/homepage' /> : ''}
            <Container className="d-flex justify-content-center">
                <div className="mt-5 shadow w-75">
                    <h1 className="text-center mt-4 ml-5 mr-5 mb-3">Profile Page</h1>
                    <h4 className="text-center mb-5">{userName}님 환영합니다 !</h4>

                    <div className="d-flex justify-content-center mb-3" id="defaultImg">
                        <Image src={userdefault} width="300px" roundedCircle />
                    </div>
                    <div className="d-flex justify-content-center">
                        <Form className="d-flex justify-content-center">
                            <Form.Group>
                                <div id="image_container"></div>
                                <Form.File label="프로필 사진 변경" accept="image/*" onChange={setThumbnail} />
                            </Form.Group>
                        </Form>
                    </div>

                    <div className="text-center">
                        <div className="m-3">이름 : {userName}</div>
                        <div className="m-3" id="nickname">별명 : {userNickname}
                            <Button className="ml-3" variant="outline-primary" size="sm" onClick={editNickname1}>수정</Button>
                        </div>
                        <div className="m-3">이메일 : {userEmail}</div>
                    </div>
                    <div className="text-center m-5">
                        <span>
                            <Button variant="outline-success" size="sm" className="mr-4">저장</Button>
                            <Button variant="outline-success" size="sm" className="ml-4" onClick={goHome}>홈 화면으로</Button>
                        </span>
                    </div>
                </div>
            </Container>

        </div>
    )
}

export default ProfilePage
