import React, { useState } from 'react';
import { Button, Form, Container, Navbar } from 'react-bootstrap';
import { Link } from 'react-router-dom';

function LogIn() {
    const [validated, setValidated] = useState(false);

    const handleSubmit = (event) => {
        const form = event.currentTarget;
        if (form.checkValidity() === false) {
            event.preventDefault();
            event.stopPropagation();
        }

        setValidated(true);
    };

    return (
        <>
            <Navbar bg="dark" variant="dark">
                <Navbar.Brand>YDK Messenger</Navbar.Brand>
            </Navbar>

            <Form noValidate validated={validated} onSubmit={handleSubmit}>
                <Container className="d-flex justify-content-center">
                    <div className="mt-5 p-5 shadow w-75">

                        <h2 className="text-center ">로그인</h2>

                        <Form.Group controlId="formGroupEmail">
                            <Form.Label>이메일</Form.Label>
                            <Form.Control
                                required
                                type="text"
                                placeholder="이메일을 입력해주세요" />
                            <Form.Control.Feedback type="invalid">
                                필수 정보입니다! 이메일을 입력해주세요!
                        </Form.Control.Feedback>
                        </Form.Group>

                        <Form.Group controlId="formGroupPassword">
                            <Form.Label>비밀번호</Form.Label>
                            <Form.Control
                                required
                                type="text"
                                placeholder="비밀번호를 입력해주세요" />
                            <Form.Control.Feedback type="invalid">
                                필수 정보입니다! 비밀번호를 입력해주세요!
                        </Form.Control.Feedback>
                        </Form.Group>

                        <Link to="./homepage">
                            <Button type="submit" variant="outline-success" size="lg" className="mr-4" block>로그인</Button>
                        </Link>

                        <Link to="./signuppage">
                            <h6 type="button" className="text-right mt-2" style={{ cursor: 'pointer' }}>회원가입</h6>
                        </Link>
                    </div>
                </Container>
            </Form>
        </>
    );
}

//render(<LogIn />);


export default LogIn