import express from 'express'
import userCtrl from '../controllers/user.controller.js'

const router = express.Router()
//router의 역할 : './주소'부분을 처리하는 역할함. 

router.route('/users/signup')
    .post(userCtrl.signup)


router.route('/users/check')
    .get(userCtrl.checkUser)

router.route(`/users/:userId`)
    .get(userCtrl.getProfile)
    .put(userCtrl.profileUpload, userCtrl.update)


router.param('userId', userCtrl.userById)



export default router