import React, { useState, useEffect } from 'react'
import { Badge, Button, ListGroup } from 'react-bootstrap';
import axios from 'axios'

function ClosedList(props) {

  const [list, setList] = useState([]);

  useEffect(() => {
    getClosedList();
  }, [props.roomCode]);

  useEffect(() => {
    console.log('안읽은정보', props.leaveInfo)
  }, [props.leaveInfo])

  async function getClosedList() {
    const userid = sessionStorage.getItem('userId')
    let res = await axios.get('/room/closedlist', { params: { '_id': userid } })
    setList(res.data)
  }

  function enterChatRoomCH(e) {
    const roomCode = e.target.name
    const roomName = e.target.value
    props.enterChatRoom(roomCode)
    props.setRoomCode(roomCode)

  }


//   async function unreadMessage() {
//     //여기서 나간시간과 db의 메세지와 시간비교해서 개수를 count해주면 됨
//     //물론 그 방 별로 찾아서 list를 맵써서 하던?
//     const respond = await axios.get('/room/unreadMessage', { params: { 'leaveInfo': props.leaveInfo, 'roomId': 'fd5243a90f' } })
//     console.log('클라이언트 클로즈드 카운드', respond)
//     // console.log('클라이언트 unreadmsg',respond.data)
//     const respond222 = await axios.get('/room/dbChat')
//     return respond
//   }
// let c=''
//   useEffect(() => {
//     c =unreadMessage()
//     console.log('클로즈드 이펙트',c)
    
//   },[])

  return (
    <div>
      {list.map((item, index) =>
        <ListGroup key={index}>
          <ListGroup.Item action onClick={enterChatRoomCH} name={item.roomId} value={item.roomName}>
            {item.roomName}
            {/* <Badge className='ml-2' pill variant='danger'>8</Badge> */}
          </ListGroup.Item>
        </ListGroup>
      )}
    </div>
  )
}

export default ClosedList
