import React, { useState, useEffect } from 'react'
import { Navbar, Nav, Button } from 'react-bootstrap';
import { Link } from 'react-router-dom';
import { handleLogout } from '../utils/auth';
import axios from 'axios'


function Menu() {

  const name = sessionStorage.getItem('name');

  return (
    <Navbar bg="dark" variant="dark">
      <Navbar.Brand href="/home">YDK Messenger</Navbar.Brand>
      <div className='ml-1 mr-2' style={{ color: 'white' }}>{name} 님 환영합니다</div>
      <Nav className="mr-auto">
        <Nav.Link href="/home">Home</Nav.Link>
        <Nav.Link href="/profile">Profile</Nav.Link>
        <Nav.Link href="/hello">Hello</Nav.Link>
      </Nav>
      <Link to="./login">
        <Button onClick={() => handleLogout()} variant="light" className="ml-3">Logout</Button>
      </Link>
    </Navbar>
  )
}

export default Menu
