import React from 'react'
import { Navbar, Nav, Button } from 'react-bootstrap';
import { handleLogout } from '../utils/auth';


function Menu() {

  const name = sessionStorage.getItem('name');

  return (
    <Navbar bg="dark" variant="dark">
      <Navbar.Brand href="/home">YDK Messenger</Navbar.Brand>
      {name ?
        <>
          <div className='ml-1 mr-2' style={{ color: 'white' }}>{name}님 환영합니다</div>
          <Nav className="mr-auto">
            <Nav.Link href="/profile">Profile</Nav.Link>
          </Nav>
          <Button className="ml-auto" onClick={() => handleLogout()} variant="light">Logout</Button>
        </>
        : <Nav className="ml-auto">
          <Nav.Link href='/login'>로그인</Nav.Link>
          <Nav.Link href='/signup'>회원가입</Nav.Link>
        </Nav>}
    </Navbar>
  )
}

export default Menu
