import React, { useState } from 'react'
import { Navbar, Nav } from 'react-bootstrap';
import { handleLogout } from '../utils/auth';
import styled from 'styled-components';
import { BsPeopleCircle  } from "react-icons/bs";
import { AiOutlineLogout } from "react-icons/ai";

function Menu() {
  const [showIcon, setShowIcon] = useState(false);

  const name = sessionStorage.getItem('name');

  console.log('showIcon', showIcon)
  return (
    <MenuDiv setShowIcon={setShowIcon}>
      <Navbar style={{ backgroundColor: "#61477a", heigth: "100%" }} variant="dark">
        <div className="container-fluid">
          <Navbar.Brand className="navbar-brand" href="/home">YDK Messenger</Navbar.Brand>
          {name ?
            <>
              <Nav className="nav navbar-nav mr-auto" style={{ color: 'white' }}>
                <Nav.Item className="mt-2 mr-4">{name}님 환영합니다</Nav.Item>
                { showIcon ?
                <a href="/profile"><BsPeopleCircle size="15" color="#FFFFFF"/></a>
                :<Nav.Link href="/profile">Profile</Nav.Link>}
                { showIcon ?
                <a href="/login" onClick={() => handleLogout()}><AiOutlineLogout size="15" color="#FFFFFF"/></a>
                :<Nav.Link onClick={() => handleLogout()} href="/login">logout</Nav.Link>}
              </Nav>
            </>
            : <>
              <Nav className="nav navbar-nav">
                <Nav.Link href="/login">Login</Nav.Link>
                <Nav.Link href="/signup">Signup</Nav.Link>
              </Nav>
            </>}
        </div>
      </Navbar>
    </MenuDiv>
  )
}

const MenuDiv = styled.div`
@media (max-width: 500px) {
    display: 'none';
   }
`


export default Menu
