import React from 'react'
import { Nav } from 'react-bootstrap';
import { handleLogout } from '../utils/auth';
import { BsPeopleCircle } from "react-icons/bs";
import { AiOutlineLogout } from "react-icons/ai";
import "../menu.css";

function Menu(props) {

  const name = sessionStorage.getItem('name');

  return (
    <div className="container-fluid" style={{ display: "flex", flexDirection: "row", backgroundColor: "#61477a", heigth: "100%", position: "relative" }}>
      <a href="/" className="navbar-brand" href="/home" style={{ color: 'white', alignItems: "center" }}>{'YDK Messenger'}</a>
      {name ?
        <>
          <div className="nav navbar-nav mr-auto" style={{ color: 'white', display: "flex", flexDirection: "row", alignItems: "center" }}>
            <p className="mt-2 mr-4">{`${name}님 환영합니다`}</p>
            <div className="showText">
              <a href="/profile" style={{ color: "#FFFFFF", marginRight: "15px" }}>{'Profile'}</a>
              <a onClick={() => handleLogout()} href="/login" style={{ color: "#FFFFFF" }}>{'logout'}</a>
            </div>
            <div className="showIcon">
              <a href="/profile" style={{ marginRight: "15px" }}><BsPeopleCircle size="25" color="#FFFFFF" /></a>
              <a href="/login" onClick={() => handleLogout()}><AiOutlineLogout size="25" color="#FFFFFF" /></a>
            </div>
          </div>
        </>
        : <>
          <div className="nav navbar-nav" style={{ display: "flex", flexDirection: "row", alignItems: "center" }}>
            <div className="showTextBFLogin">
              <a href="/login" style={{ color:"#FFFFFF", marginRight: "15px" }}>{'Login'}</a>
              <a href="/signup" style={{ color:"#FFFFFF" }}>{'Signup'}</a>
            </div>
          </div>
        </>}
    </div>
  )
}

export default Menu
