import React, { useState, useEffect } from 'react'
import { ListGroup } from 'react-bootstrap';
import axios from 'axios'

function OpenList(props) {
  const [openlist, setOpenlist] = useState([]);

  useEffect(() => {
    getOpenList();
  }, [props.roomCode]);

  async function getOpenList() {
    let res = await axios.get('/room/openlist')
    setOpenlist(res.data)
  }


  function enterChatRoomCH(e) {
    const roomCode = e.target.code
    props.enterChatRoom(roomCode) // 각각의 room으로 들어가도록 설정해야 함
  }

  return (
    <div>
      {openlist.map((item, index) =>
        <ListGroup key={index}>
          <ListGroup.Item action onClick={enterChatRoomCH} code={item.roomId}>
            {item.roomName}
          </ListGroup.Item>
        </ListGroup>
      )}
    </div>
  )
}

export default OpenList
