import axios from 'axios';
import React, { useState, useEffect } from 'react';
import { Form, Button, Row, Image, Col, Container } from 'react-bootstrap';
import { isAuthenticated } from '../utils/auth';
import catchErrors from '../utils/catchErrors';


const INIT_CHAT = {
  msg: '',
  sender: '',
  img: '',
  time: ''
}
function Chat(props) {
  //const [sender, setSender] = useState([])

  //const [roomName, setRoomName] = useState('')
  const [inner, setInner] = useState([''])
  const [chat, setChat] = useState([INIT_CHAT])   //object로 key는 보낸사람 value는 메세지

  const simpleTime = new Date().toLocaleTimeString()
  const usualTime = simpleTime.substring(0, simpleTime.length - 3)
  const realTime = new Date().toISOString()

  const [disabled, setDisabled] = useState(true)
  const [user, setUser] = useState('')
  const [error, setError] = useState('');

  const [exit, setExit] = useState(false);

  const userId = isAuthenticated()

  async function getProfile(userId) {
    try {
      const response = await axios.get(`/users/${userId}`)
      setUser(response.data)
    } catch (error) {
      catchErrors(error, setError)
    }
  }

  function handleChange(e) {
    e.preventDefault()
    setInner(e.target.value)
    setDisabled(false)
    //console.log(chat)
  }

  function sendMsgCH(e) {
    e.preventDefault()

    props.setSingleTime(usualTime)
    props.setSingleImg(user.profileimg)
    props.setSingleUser(user.nickname)
    props.setSingleChat(inner)
    props.sendMsg(e)
    setInner('')
    setDisabled(true)
  }

  function handleClick() {
    props.closeChatRoom(props.roomCode)
    props.setRecievedMsg('')
    props.handleChatc()
    props.setLeaveInfo([...props.leaveInfo, { roomName: props.roomCode, leaveTime: realTime }])
    console.log('나간시간', realTime, usualTime)
    setChat([''])

    props.handleChatc()
    props.setLeaveInfo([...props.leaveInfo, { roomName: props.roomCode, leaveTime: realTime }])
  }

  function settingtime(hour) {
    let newhour = parseInt(hour) + 9
    if (newhour >= 24) {
      newhour -= 24
    }
    if (newhour >= 13) {
      newhour -= 12
      newhour = '오후 ' + newhour
    } else {
      newhour = '오전 ' + newhour
    }
    return newhour
  }

  //이전 채팅 내용에 대한 것 불러오기
  //프사 닉네임 메세지가 각각의 배열로 들어가서 띄워지는 방식
  async function getPreviousChat() {
    const respond = await axios.get('/room/getChatInfo', { params: { 'roomCode': props.roomCode } })
    console.log(respond)
    const info = respond.data

    let intochat = []
    for (let prop in info) {
      let hour = info[prop].createdAt.split('T')[1].split(':')
      hour = settingtime(hour[0]) + ':' + hour[1]
      intochat.push({ msg: info[prop].message, sender: info[prop].username, img: info[prop].profileimg, time: hour })
    }
    setChat(intochat)
  }

  async function exitAndCloseRoom() {
    props.exitRoom(props.roomCode)
    setExit(false)
    props.handleChatc()
  }


  useEffect(() => {
    getProfile(userId)
  }, [userId])

  useEffect(() => {
    setChat([...chat, { msg: props.singleChat, sender: props.singleUser, img: props.singleImg, time: props.singleTime }])
  }, [props.singleChat])

  useEffect(() => {
    setChat([...chat, { msg: props.recievedMsg, sender: props.recievedUser, img: props.recievedImg, time: props.recievedTime }])
  }, [props.recievedMsg])

  useEffect(() => {
    getPreviousChat()
    // console.log('겟 룸네임', chat)
  }, [props.roomCode])


  return (
    <>
      <Container id="chat" style={{ overflow: 'auto', padding: '20px', border: "2px solid", height: "500px", margin: "1%", borderColor: "#BDBDBD", background: '' }}>
        <Row className="justify-content-center" style={{ border: "2px solid", borderWidth: "medium", borderColor: "#FFD75F", height: "80px" }}>
          <Col md="auto">
            <Button variant="light" onClick={handleClick} >{`<`}</Button>
          </Col>
          <Col>
            <Row style={{ fontWeight: "bold", fontSize: "x-large" }}> {props.roomName} </Row>
            <Row > {props.roomCode} </Row>
          </Col>
          <Col md="auto">
            <Button variant="light" onClick={() => setExit(true)}>{'='}</Button>
          </Col>
        </Row>
        {exit ?
          <Row>
            <Col>퇴장하시겠습니까?</Col>
            <Col md="auto"><Button variant="light" onClick={exitAndCloseRoom}>{"나가기"}</Button></Col>
          </Row>
          : null}
        {chat.map((value, index) => {
          if (!(value.msg === '')) {
            if (value.sender === "system") {
              return (
                <Row className='border' style={{ background: "#FFFAFA"}}>
                  {value.msg}
                </Row>
              )
            } else if (!(value.sender === user.nickname)) {
              return (
                <Row key={index} className='m-1' >
                  <Col xs={2}>
                    <Image src={value.img && `/images/${value.img}`} style={{ width: "50px", height: "50px" }} roundedCircle />
                  </Col>
                  <Col xs={8}>
                    <Row><strong>{value.sender}</strong></Row>
                    <Row className='d-flex flex-wrap-nowrap'>
                      <Row className='border border-dark' style={{ width: 'max-content', maxWidth: '300px', height: 'auto', paddingLeft: '15px', paddingRight: '15px', background: 'white', borderRadius: '5px', fontSize: 'x-large' }}>{value.msg}</Row>
                      <Col className='ml-1'>{value.time}</Col>
                    </Row>
                  </Col>
                </Row>
              )
            } else {
              return ( //내가 보낸 메시지
                <Row key={index} className='m-1 justify-content-end'>
                  <Row className='d-flex flex-wrap-nowrap' >
                    <Col className='mr-1'>{value.time}</Col>
                    <Row className='mr-2' name='msg' style={{ width: 'max-content', maxWidth: '300px', height: 'auto', paddingLeft: '15px', paddingRight: '15px', background: 'yellow', borderRadius: '3px', fontSize: 'x-large' }}>{value.msg}</Row>
                  </Row>
                </Row>
              )
            }
          } else {
            return null
          }
        })
        }

      </Container >
      <Form onSubmit={sendMsgCH} fluid>
        <Form.Group className='d-flex flex-wrap-nowrap justify-content-center m-3'>
          <Form.Control className='border border-warning' name='chat' type="text" value={inner} onChange={handleChange} style={{ width: '85%' }} />
          <Button variant="warning" type="submit" disabled={disabled} style={{ width: '10%' }}>
            전송
          </Button>
        </Form.Group>
      </Form>
    </>


  );
}


export default Chat;

