import User from "../models/User.js"
import bcrypt from 'bcryptjs'
import jwt from 'jsonwebtoken'
import config from "../config.js"
//server부분에는 꼭 js붙여주기!!

//sign validation해야됨
const login = async (req, res) => {
    const { email, password } = req.body

    try {
        const user = await User.findOne({ email }).select('+password')
        if (!user) {
            return res.status(404).send(`${email}을 사용하는 사용자가 없습니다`)
        }
        const passwordMatch = await bcrypt.compare(password, user.password)
        if (passwordMatch) {
            //토큰 생성
            const token = jwt.sign({ userId: user._id}, config.jwtSecret, {expiresIn: '7d'})
            //jwtSecret : 노출되면 안됨. 문자열
            //expiresIn: '7d' -> 만기날짜 : 만든 7일후 만기

            //쿠키에 저장
            //res : client로 넘어가는 객체 cookie('이름', value)
            res.cookie('token', token, {
                maxAge: config.cookieMaxAge,
                //생성일로부터 어느정도까지 살아있을 것인가
                httpOnly: true,
                //client에서 javascript로 접근할 수 없음
                secure: config.env === 'production',
                //secure가 true이면 http로 접근하면 cookie가 들어가지 않음.
            })
            console.log('res.send.user', {user})
            res.send({user})

        } else {
            // 5) 비밀번호가 틀리면 에러 반환
            res.status(401).send('비밀번호가 일치하지 않습니다')
        }
        
    } catch (error) {
        //알수없는 모든 에러발생시 처리
        console.log(error)
        res.status(500).send('로그인 에러가 발생하였습니다')
    }
}

const logout = (req, res) => {
    res.clearCookie('token')
    res.send('로그아웃 되었습니다')
}

export default { login, logout }
// {} : 객체로 return함
