import React, { useState, useEffect } from 'react';
import { Row, Col, Button } from 'react-bootstrap';
import Tabs from 'react-bootstrap/Tabs';
import Tab from 'react-bootstrap/Tab';
import ClosedList from '../Components/ClosedList';
import OpenList from '../Components/OpenList';
import Menu from '../Components/Menu';
import { io } from "socket.io-client";   //모듈 가져오기
import Chat from "../Components/Chat";
import RoomMake from "../Components/RoomMake"
import EnterRoom from "../Components/EnterRoom"

const socket = io();

function Home() {
    const [showModal, setShowModal] = useState(false);
    const [showEnter, setEnter] = useState(false);
    const [chat, setChat] = useState(false);

    //소켓
    const [singleChat, setSingleChat] = useState('')
    const [recievedMsg, setRecievedMsg] = useState('')
    const [roomCode, setRoomCode] = useState('')

    //방참가

    const [roomName, setRoomName] = useState('')

    const handleCloseModal = () => setShowModal(false);
    const handleShowModal = () => setShowModal(true);
    const handleCloseEnter = () => setEnter(false);
    const handleShowEnter = () => setEnter(true);
    const handleChato = () => setChat(true);
    const handleChatc = () => setChat(false);



    //SOCKET 관련 시작
    function enterChatRoom(rName) {    //방 입장하기
        socket.emit('joinRoom', rName)
        console.log(`joinRoom : ${rName} 입장`)
    }

    const sendMsg = (e) => {
        e.preventDefault()
    }

    useEffect(() => {
        if (!(singleChat == '')) {
            socket.emit("chat", {
                roomInfo: roomCode,
                msg: singleChat
            })
            setSingleChat([''])
        }
    }, [singleChat])


    useEffect(() => {
        socket.on("sendedMSG", (msg) => {
            console.log(msg)
            setRecievedMsg(msg)
        })
    }, [])

    return (
        <>
            <Menu />
            <Row className="mr-0">
                <Col className="list" md={5}>
                    <Tabs defaultActiveKey="closed" id="uncontrolled-tab-example">
                        <Tab eventKey="closed" title="내 채팅" onClick={handleChato} >
                            <ClosedList enterChatRoom={enterChatRoom} setRoomCode={setRoomCode} />
                        </Tab>
                        <Tab eventKey="open" title="공개방" onClick={handleChato}>
                            <OpenList enterChatRoom={enterChatRoom} setRoomCode={setRoomCode} />
                        </Tab>
                    </Tabs>
                </Col>
                <Col style={{ padding: "0" }}>
                    {chat ? <Chat handleChatc={handleChatc} sendMsg={sendMsg} singleChat={singleChat} recievedMsg={recievedMsg} setSingleChat={setSingleChat} roomCode={roomCode} /> : null}

                    <div style={{ position: "fixed", bottom: "20px", right: "30px" }}>
                        <Button variant="primary" onClick={handleShowModal} size="lg" block>
                            생성
                        </Button>

                        <Button variant="secondary" onClick={handleShowEnter} size="lg" block>
                            참가
                        </Button>
                    </div>
                </Col>
            </Row>
            <RoomMake showModal={showModal} handleCloseModal={handleCloseModal} />
            <EnterRoom showEnter={showEnter} enterChatRoom={enterChatRoom} handleCloseEnter={handleCloseEnter} handleChato={handleChato} setRoomName={setRoomName}/>
        </>
    );
}

export default Home;

