import express from 'express'
import roomCtrl from '../controllers/room.controller.js'

const router = express.Router()

router.route('/room/makeRoom')
    .post(roomCtrl.makeRoom)

router.route('/room/changeMem')
    .put(roomCtrl.changemember)
    .get(roomCtrl.roomInf)

router.route('/room/closedlist')
    .get(roomCtrl.getClosedList)

router.route('/room/openlist')
    .get(roomCtrl.getOpenList)

router.route('/room/member')
    .put(roomCtrl.changemember)

router.route('/room/getRoomName')
    .get(roomCtrl.getRoomName)

router.route('/room/unreadMessage')
    .get(roomCtrl.unreadMessage)

router.route('/room/dbChat')
    .get(roomCtrl.dbChat)

export default router