//로그인 한 사람만 route로 이동할 수 있도록 함
import React from 'react'
import { Redirect, Route } from 'react-router-dom'
import { isAuthenticated } from '../utils/auth'

function PrivateRoute({path, children}) {
    if (isAuthenticated()) {
        //로그인이 됬을 시 정상적으로 작동
        return (
            <Route path={path}>
                {children}
            </Route>
        )
    } else {
        //로그인이 되지 않았을 시 로그인페이지로 이동
        return (
            <Redirect to='./login' />
        )
    }
}

export default PrivateRoute
