import mongoose from 'mongoose'

const { String } = mongoose.Schema.Types

const AccessInfoSchema = new mongoose.Schema({
  room: {
    type: mongoose.ObjectId,
    required: true,
    ref: 'Room',
  },
  userInfo: {
    type: mongoose.ObjectId,
    required: true,
    unique: true,
    ref: 'User',
  },
  nickname: {
    type: String,
    required: true,
  },
  isEnt: {
    type: Boolean,
    required: true,
    default: true, // 입장 시 true, 퇴장 시 false
  }
}, {
  timestamps: true
})

export default mongoose.models.AccessInfo || mongoose.model('AccessInfo', AccessInfoSchema)