import express from 'express'
import connectDb from './utils/connectDb.js'
import chatRouter from './routes/chat.routers.js'
import cors from "cors"
import bodyParser from "body-parser"
import http from 'http'
import { Server } from 'socket.io'

connectDb()

const app = express()

app.use(express.json())
app.use(chatRouter)

const server = http.createServer(app);

const io = new Server(server);

// const port = process.env.PORT || 3001; // 3001 수정해야하나?

app.use(bodyParser.json());

app.use(cors());
// app.use('/', indexRouter);

io.on("connection", (socket) => { // 기본 연결
  console.log("socket connect ok", socket.id)

  socket.on('joinRoom', (data)=>{ // joinRoom을 클라이언트가 emit했을 때
    let roomName=data;
    socket.join(roomName); //클라이언트에서 data에 적힌 room으로 참여시킴
  });

  socket.on('chat', (data)=>{
    io.to(data.roomName).emit('broadcast',data.msg); //roomName에 존재하는 모든 소켓들에게 
  })

  socket.on('disconnect', () => {
    console.log('disconnected from server id=', socket.id)
  })
  
});

server.listen(3030, () => {
    console.log('Listening on port 3030')
})
// server.listen(port, () => { console.log(`Listening on port ${port}`) });

export default server
// module.exports = server;