import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { Row, Col, Modal, Button, Form, Alert } from 'react-bootstrap';
import Tabs from 'react-bootstrap/Tabs';
import Tab from 'react-bootstrap/Tab';
import ClosedList from '../Components/ClosedList';
import OpenList from '../Components/OpenList';
import Menu from '../Components/Menu';
import catchErrors from '../utils/catchErrors';
import { io } from "socket.io-client";   //모듈 가져오기
import Chat from "../Components/Chat";
// import styled from 'styled-components';

// const List = styled.div`
//   background: #FFFAFA;
// `

const socket = io();

const INIT_CHATR = {
    name: '',
    interest: '',
    isOpen: false
}

function Home() {
    const [show, setShow] = useState(false);
    const [show2, setShow2] = useState(false);
    const [chat, setChat] = useState(false);
    const [chatR, setChatR] = useState(INIT_CHATR);
    const [disabled, setDisabled] = useState(true);
    const [error, setError] = useState('');

    const [singleChat, setSingleChat] = useState('')
    const [roomName, setRoomName] = useState('')

    const handleClose = () => setShow(false);
    const handleShow = () => setShow(true);
    const handleChato = () => setChat(true);
    const handleChatc = () => setChat(false);
    const handleClose2 = () => setShow2(false);
    const handleShow2 = () => setShow2(true);
    // variant="pills"

    useEffect(() => {
        const isChatR = Object.values(chatR).every(el => Boolean(el))
        isChatR ? setDisabled(false) : setDisabled(true)
    }, [chatR])

    function handleChange(event) {
        const { name, value } = event.target
        setChatR({ ...chatR, [name]: value })
    }

    async function handleSubmit(event) {
        event.preventDefault()
        try {
            setError('')
            const response = await axios.post('chat/makeChat', chatR)
            setChatR(INIT_CHATR)
        } catch (error){
            catchErrors(error, setError)
        }
    }

    //SOCKET 관련 시작

    function enterChatroom(rName) {    //방 입장하기
        socket.emit('joinRoom', rName)
        console.log(`joinRoom : ${rName} 입장`)
    }

    const sendMsg = (e) => {
        e.preventDefault()
    }

    useEffect(() => {
        socket.emit("chat", {
            roomName: roomName,
            msg: singleChat
        })
        socket.on('broadcast', (msg) => {
            console.log(msg)
            setSingleChat(msg)
        })
    }, [singleChat])

    return (
        <>
            <Menu />
            <Row className="mr-0">
                <Col className="list" md={5}>
                    <Tabs defaultActiveKey="closed" id="uncontrolled-tab-example">
                        <Tab eventKey="closed" title="내 채팅" onClick={handleChato} >
                            <ClosedList enterChatroom={enterChatroom} setRoomName={setRoomName}/>
                        </Tab>
                        <Tab eventKey="open" title="공개방" >
                            <OpenList enterChatroom={enterChatroom} setRoomName={setRoomName}/>
                        </Tab>
                    </Tabs>
                </Col>
                <Col style={{ padding: "0" }}>
                    {chat ? <Chat handleChatc={handleChatc} sendMsg={sendMsg} singleChat={singleChat} setSingleChat={setSingleChat} roomName={roomName}/> : null}

                    <div style={{ position: "fixed", bottom: "20px", right: "30px" }}>
                        <Button variant="primary" onClick={handleShow} size="lg" block>
                            생성
                        </Button>

                        <Button variant="secondary" onClick={handleShow2} size="lg" block>
                            참가
                        </Button>
                    </div>

                    <Modal show={show} onHide={handleClose}>
                        <Modal.Header closeButton>
                            <Modal.Title>방 생성</Modal.Title>
                        </Modal.Header>
                        {error && <Alert variant='danger'>
                            {error}
                        </Alert>}
                        <Modal.Body>
                            <Form onSubmit={handleSubmit}>
                                <Form.Group as={Row} controlId="chatName">
                                    <Form.Label column sm={4}>방 이름</Form.Label>
                                    <Col>
                                        <Form.Control name='name' type='text' value={chatR.name} onChange={handleChange} />
                                    </Col>
                                </Form.Group>
                                <Form.Group as={Row} controlId="chatInterest">
                                    <Form.Label column sm={4}>관심 분야</Form.Label>
                                    <Col>
                                        <Form.Control as="select" defaultValue="Choose..." name='interest' type='text' value={chatR.interest} onChange={handleChange}>
                                            <option>Choose...</option>
                                            <option>과학</option>
                                            <option>수학</option>
                                            <option>예술</option>
                                            <option>언어</option>
                                            <option>취미</option>
                                        </Form.Control>
                                        {/* <Form.Control type="text" /> */}
                                    </Col>
                                </Form.Group>
                                <Form.Group as={Row} controlId="chatIsOpen">
                                    <Form.Label column sm={4}>공개방</Form.Label>
                                    <Col>
                                        <Form.Check
                                            type="checkbox"
                                            checked={chatR.isOpen}
                                            name='isOpen'
                                            onChange={() => setChatR({ ...chatR, isOpen: !chatR.isOpen })} />
                                    </Col>
                                </Form.Group>
                                {
                                    (chatR.isOpen)
                                        ? (<p><b>공개방</b>으로 개설되어 공개방 목록에 공개되며, 코드를 공유하여 참가할 수도 있습니다.</p>)
                                        : (<p><b>비밀방</b>으로 개설되며, 참여자들에게 코드를 공유해야합니다.</p>)
                                }
                                <Form.Group as={Row}>
                                    <Col sm={{ span: 5, offset: 4 }}>
                                        <Button type="submit" >방 생성</Button>
                                    </Col>
                                </Form.Group>
                            </Form>
                        </Modal.Body>
                    </Modal>

                    <Modal show={show2} onHide={handleClose2}>
                        <Modal.Header closeButton>
                            <Modal.Title>참여 코드로 채팅 참가</Modal.Title>
                        </Modal.Header>
                        <Modal.Body>
                            <Form onSubmit={() => { console.log('제출') }}>
                                <Form.Group as={Row} controlId="formCodeE">
                                    <Form.Label column sm={4}>참여 코드</Form.Label>
                                    <Col>
                                        <Form.Control type="text" />
                                    </Col>
                                </Form.Group>
                                <Form.Group as={Row}>
                                    <Col sm={{ span: 5, offset: 4 }}>
                                        <Button type="submit">참가</Button>
                                    </Col>
                                </Form.Group>
                            </Form>
                        </Modal.Body>
                    </Modal>
                </Col>
            </Row>
        </>
    );
}

export default Home;
