import axios from 'axios';
import React, { useState, useEffect } from 'react';
import { Form, Button, Row, Image, Col, Container } from 'react-bootstrap';
import { isAuthenticated } from '../utils/auth';
import catchErrors from '../utils/catchErrors';


function Chat(props) {
  // let defaultname = sessionStorage.getItem('name');

  const [sender, setSender] = useState([])

  const [inner, setInner] = useState([''])
  const [chat, setChat] = useState([])   //object로 key는 보낸사람 value는 메세지
  const [disabled, setDisabled] = useState(true)
  const [user, setUser] = useState('')
  const [error, setError] = useState('');

  const userId = isAuthenticated()
  async function getProfile(userId) {
    try {
      const response = await axios.get(`/users/${userId}`)
      setUser(response.data)
    } catch (error) {
      catchErrors(error, setError)
    }
  }

  function handleChange(e) {
    e.preventDefault()
    setInner(e.target.value)
    console.log(e.target.value)
    setDisabled(false)
  }

  function sendMsgCH(e) {
    e.preventDefault()

    props.setSingleUser(sessionStorage.getItem('name'))
    props.setSingleChat(inner)

    props.sendMsg(e)
    setInner('')
    setDisabled(true)
    console.log(chat)
  }
  useEffect(() => {
    getProfile(userId)
  }, [userId])

  useEffect(() => {
    setSender([...sender, props.singleUser])
    console.log('UseEffect singleUser', sender)

    setChat([...chat, props.singleChat])
    // console.log('UseEffect singlechat', chat)

    console.log('Chat에 Sing있는 name = ', props.singleUser)

  }, [props.singleChat])

  useEffect(() => {
    setSender([...sender, props.recievedUser])
    console.log('UseEffect RecievedUser', sender)
    console.log('Chat에 Reci있는 name = ')

    setChat([...chat, props.recievedMsg])
    // console.log('UseEffect recievechat', chat)
  }, [props.recievedMsg])

  const time = new Date().toLocaleTimeString()
  return (
    <Container className="chat" id="chat" style={{ padding: '20px', border: "2px solid", height: "300%", margin: "1%", borderColor: "#BDBDBD", background: '' }}>
      <h2>해당 방에 대한 참여코드는 {props.roomCode} 입니다.</h2>
      {/* 상대방이 보낸 메세지 띄우기 + 같은유저면 프로필 이미지는 생략(chat을 object로 보낸사람과 함께 보내서 구분하자) */}
      {chat.map((value, index) => {
        if (!(value == '')) {
          if (!(sender[index] === sessionStorage.getItem('name'))) {
            return (
              <Row key={index} className='m-1' >
                <Col xs={2}>
                  {user.profileimg ? <Image src={user.profileimg && `/images/${user.profileimg}`} style={{ width: "50px", height: "50px" }} roundedCircle /> : <Image src='https://www.flaticon.com/svg/vstatic/svg/149/149071.svg?token=exp=1610922596~hmac=f4b972b9db509d4e3cc2eb40543b0b0f' style={{ width: "50px", height: "50px" }} roundedCircle />}
                </Col>
                <Col xs={8}>
                  <Row><strong>{sender[index]}</strong></Row>
                  <Row className='d-flex flex-wrap-nowrap'>
                    <Row className='border border-dark' style={{ width: 'max-content', maxWidth: '300px', height: 'auto', paddingLeft: '15px', paddingRight: '15px', background: 'white', borderRadius: '5px', fontSize: 'x-large' }}>{value}</Row>
                    <Col className='ml-1'>{time}</Col>
                  </Row>
                </Col>
              </Row>
            )
          } else {
            return (
              <Row key={index} className='m-1 justify-content-end'>
                <Row className='d-flex flex-wrap-nowrap' >
                  <Col className='mr-1'>{time}</Col>
                  <Row className='mr-2' style={{ width: 'max-content', maxWidth: '300px', height: 'auto', paddingLeft: '15px', paddingRight: '15px', background: 'yellow', borderRadius: '3px', fontSize: 'x-large' }}>{value}</Row>
                </Row>
              </Row>
            )
          }
        } else {
          return null
        }
      })
      }

      <Button variant="light" onClick={props.handleChatc} >{`<`}</Button>
      <Form onSubmit={sendMsgCH}>
        <Form.Group className='d-flex flex-wrap-nowrap justify-content-center ml-2 mr-2'>
          <Form.Control className='border border-warning' name='chat' type="text" value={inner} onChange={handleChange} style={{ width: '85%' }} />
          <Button variant="warning" type="submit" disabled={disabled} style={{ width: '10%' }}>
            전송
          </Button>
        </Form.Group>

      </Form>
    </Container >


  );
}


export default Chat;
