import express from 'express'
import connectDb from './utils/connectDb.js'
import userRouter from './routes/user.routes.js'
import authRouter from './routes/auth.routes.js'
import roomRouter from './routes/room.routers.js'
import roomEnterRouter from './routes/roomEnter.routers.js'
import bodyParser from "body-parser";
import http from "http";
import { Server } from 'socket.io';
import cors from "cors"

connectDb()

const app = express()

const server = http.createServer(app);

const io = new Server(server)

io.on("connection", (socket) => { // 기본 연결
  console.log("socket connect ok", socket.id)

  socket.on('joinRoom', (data)=>{ // joinRoom을 클라이언트가 emit했을 때
    console.log('join_data확인',data)
    let roomInfo=data;
    socket.join(roomInfo); //클라이언트에서 data에 적힌 room으로 참여시킴
  });

  socket.on('chat', (data) => {
    console.log('roomname확인', data)
    socket.broadcast.to(data.roomInfo).emit('sendedMSG', data.sendInfo ); // sender 제외 특정 방으로  
  });


  socket.on('disconnect', () => {
    console.log('disconnected from server id=', socket.id)
  })
  
});

app.use(bodyParser.json());
app.use(cors());

app.use('/images', express.static('uploads/'))
app.use(userRouter)
app.use(authRouter)
app.use(roomRouter)
app.use(roomEnterRouter)

server.listen(3030, () => {
  console.log('Listening on port 3030')
})

export default server
// module.exports = server;
