import axios from "axios"

//자동으로 sessionStorage에 login이 생성됨
export function handleLogin(userId) {
    sessionStorage.setItem('user', userId)
}

export async function handleLogout() {
    sessionStorage.removeItem('user')
    await axios.get('/auth/logout')
    //login페이지로 이동
    window.location.href='/login'
}

//login이 됬는지 안됬는지 따질때 쓰임
export function isAuthenticated() {
    const userId = sessionStorage.getItem('user')
    if (userId) {
        return userId
    } else {
        return false
    }
}