import mongoose from 'mongoose'

const {String} = mongoose.Schema.Types

const ChatSchema = new mongoose.Schema({
    roomId: {
        type: String,
        // default:() => nanoid(),
        unique: true
        //ref:'Room' -> Room의 형식을 참고할 수 있다.
    },
    name: {
        type: String,
        required: true,
    },
    interest: {
        type: String,
        required: true,
        select: false
    },
    isOpen: {
        type: Boolean,
        required: true,
    }
}, {
    timestamps: true
})

export default mongoose.models.ChatSchema || mongoose.model('chat', ChatSchema)