import mongoose from 'mongoose'

const {String} = mongoose.Schema.Types

const RoomSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true,
    },
    interest: {
        type: String,
        required: true,
        select: false
    },
    isOpen: {
        type: String,
        required: true,
        default: 'user',
        enum: ['user', 'admin', 'root']
    }
}, {
    timestamps: true
})

export default mongoose.models.RoomSchema || mongoose.model('Room', RoomSchema)
