import React from 'react';
import { Form, Button, Row } from 'react-bootstrap';


function Chat(props) {
  let defaultname = sessionStorage.getItem('name');

  function handleChange(e) {
    e.preventDefault()
    props.setInner(e.target.value)
    console.log(e.target.value)
  }

  function sendMsgCH(e) {
    props.sendMsg(e)
  }

  return (

    <div className="chat" id="chat" style={{ border: "2px solid", height: "300%", margin: "1%", borderColor: "#BDBDBD" }}>
      <Button variant="light" onClick={props.handleChatc} >{`<`}</Button>

      <h2>현재 {props.roomName} 입니다.</h2>
      {      props.chatmsg.map((value, index) => (
        <Row key={index} className='ml-3'>
          {props.roomName}에서 {defaultname}님이 보낸 메세지 : {value}
        </Row>
      ))}

      <Form onSubmit={sendMsgCH}>
        <Form.Control name='msg' type='text' onChange={handleChange} />
        <Button variant="primary" type="submit">전송</Button>
      </Form>
    </div>


  );
}

export default Chat;
