import mongoose from "mongoose";

const validateEmail = (email => {
    const re = /^\w+([\,-]?\w+)*@\w+([\,-]?\w+)*(\.\w{2,3})+$/; 
    return re.test(email)
})

const schema = new mongoose.Schema({
    email:{
        type: String,
        rquired: true,
        unique: true,
        validate: [validateEmail, "이메일을 입력해주세요."],
    },
    name: {type:string}, 
    password: { type: string, required: true, select: false},
    role:{type:schema.types.objectId, ref: "Role"},
    }
);

export default schema;