import { Schema, model } from "mongoose";

const validateEmail = (email) => {
  const re = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/;
  return re.test(email);
};

const schema = new Schema({
  // Schema는 데이터를 만드는 틀

  email: {
    // email 이라는 column을 만듦, email에 대한 옵션 설정
    type: String,
    // type은 항상 지정해야 함
    required: true,
    // email이 꼭 필요하다는 의미로, email을 입력하지 않으면 에러 발생
    unique: true,
    // 이메일이 중복되면 안 된다는 의미로, 중복 입력시 에러 발생
    validate: [validateEmail, "이메일을 입력해주세요"],
    // true이면 validateEmail을, false이면 "이메일을 입력해주세요"을 나타냄
  },

  name: { type: String },
  // name 이라는 column을 만듦

  password: { type: String, required: true, select: false },
  // password 라는 column을 만듦

  role: { type: Schema.Types.ObjectId, ref: "Role" },
  // role 이라는 column을 만듦
});

export default model("User", schema);
// 변수 schema를 User라는 이름으로 내보낸다
