import { useState } from "react";
import { useParams } from "react-router";
import roomApi from "../../apis/room.api";

const INIT_Channel = {
  id: "",
  channelName: "",
  number: "",
};

const ChannelSettingChange = (props) => {
  const [Channel, setChannel] = useState(INIT_Channel);
  const [error, setError] = useState("");
  const { roomId } = useParams();
  //console.log(props.channel.[0].channelName) //각 채널의 채널이름.
  Channel.id = roomId;

  const updateinfo = (event) => {
    const { channelName, value } = event.target;
    setChannel({ ...Channel, channelName: value });
    console.log(Channel.channelName);
  };

  async function CreateChannel(e) {
    let count = 0;
    for (let a = 0; a < props.channel.length; a++) {
      if (Channel.channelName === props.channel[a].channelName) {
        count += 1;
      }
    }

    if (count == 1) {
      alert("이미 존재하는 채널 입니다. 다른 이름을 입력해 주십시오.");
    } else {
      Channel.number = props.channel.length;
      alert("채널이 성공적으로 생성되었습니다.");
      window.location.reload();
      const data = await roomApi.makeChannel(Channel);
    }
  }

  async function DeleteChannel(e) { 
    let count = 0;
    for (let a = 0; a < props.channel.length; a++) {
      if (Channel.channelName === props.channel[a].channelName) {//일치하면
        count = count + 1;
         Channel.number = a;
      }
    }

    if (count === 1){
      alert("채널이 성공적으로 삭제되었습니다.");
      window.location.reload();
      const data = await roomApi.channelDelete(Channel);
    }
    else {
      alert(
        "입력한 채널명과 일치하는 채널이 존재하지 않습니다. 다시 확인해 주십시오."
      );
    }
  };

  return (
    <div>
      <button
        type="submit"
        data-bs-toggle="modal"
        data-bs-target="#changechannel"
        style={{
          weight: "100px",
          height: "60px",
          backgroundColor: "#f5cfe3",
          borderRadius: "5px",
          color: "black",
          border: "1px #f5cfe3",
        }}
      >
        채널 설정 변경
      </button>

      <div
        className="modal fade"
        id="changechannel"
        tabIndex="-1"
        aria-labelledby="changechannelLabel"
        aria-hidden="true"
      >
        <div className="modal-dialog">
          <div className="modal-content">
            <div className="modal-header">
              <div className="modal-title" id="changechannelsetting">
                채널 설정 변경
              </div>
              <button
                type="button"
                className="btn-close"
                data-bs-dismiss="modal"
                aria-label="Close"
              ></button>
            </div>
            <div className="modal-body d-flex justify-content-center"></div>
            <div className="row mb-3">
              <div
                className="d-flex justify-content-center"
                style={{ margin: "0px" }}
              ></div>
              <div className="d-flex justify-content-evenly">
                <button
                  type="submit"
                  data-bs-toggle="modal"
                  data-bs-target="#channelcreate"
                  style={{
                    weight: "100px",
                    height: "60px",
                    backgroundColor: "#f5cfe3",
                    borderRadius: "5px",
                    color: "black",
                    border: "1px #f5cfe3",
                  }}
                >
                  채널 생성
                </button>
                <button
                  type="submit"
                  data-bs-toggle="modal"
                  data-bs-target="#channeldelete"
                  style={{
                    weight: "100px",
                    height: "60px",
                    backgroundColor: "#f5cfe3",
                    borderRadius: "5px",
                    color: "black",
                    border: "1px #f5cfe3",
                  }}
                >
                  채널 삭제
                </button>

                {/* 채널생성 모달 */}
                <div
                  className="modal fade"
                  id="channelcreate"
                  tabIndex="-1"
                  aria-labelledby="channelcreateLabel"
                  aria-hidden="true"
                >
                  <div className="modal-dialog">
                    <div className="modal-content">
                      <div className="modal-header">
                        <div className="modal-title" id="createchannel">
                          채널 생성
                        </div>
                        <button
                          type="button"
                          className="btn-close"
                          data-bs-dismiss="modal"
                          aria-label="Close"
                        ></button>
                      </div>

                      <div className="row mb-3">
                        <div
                          className="d-flex justify-content-center"
                          style={{ margin: "0px" }}
                        >
                          <p style={{ marginTop: "31px", marginBottom: "0px" }}>
                            채널 이름:{" "}
                          </p>
                          <input
                            onChange={updateinfo}
                            name="channelName"
                            value={Channel.channelName}
                            type="text"
                            className="form-control my-4 "
                            placeholder="생성할 채널 이름"
                            style={{
                              background: "#fcf4ff",
                              borderTop: "0",
                              borderRight: "0",
                              borderLeft: "0",
                              borderBottom: "1",
                              borderColor: "#d4cafb",
                              height: "38px",
                              width: "170px",
                              marginTop: "0px",
                              marginBottom: "0px",
                            }}
                          />
                        </div>
                        <div className="d-flex justify-content-evenly">
                          <button
                            onClick={CreateChannel}
                            type="button"
                            className="col-2 p-1 btn btn-primary"
                          >
                            생성
                          </button>
                          <button
                            type="submit"
                            className="col-2 p-1 btn btn-primary"
                            data-bs-dismiss="modal"
                          >
                            취소
                          </button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                {/* 채널삭제 모달 */}
                <div
                  className="modal fade"
                  id="channeldelete"
                  tabIndex="-1"
                  aria-labelledby="channeldeleteLabel"
                  aria-hidden="true"
                >
                  <div className="modal-dialog">
                    <div className="modal-content">
                      <div className="modal-header">
                        <div className="modal-title" id="deletechannel__">
                          채널 삭제
                        </div>
                        <button
                          type="button"
                          className="btn-close"
                          data-bs-dismiss="modal"
                          aria-label="Close"
                        ></button>
                      </div>
                      <div className="row mb-3">
                        <div
                          className="d-flex justify-content-center"
                          style={{ margin: "0px" }}
                        >
                          <p style={{ marginTop: "31px", marginBottom: "0px" }}>
                            채널 이름:{" "}
                          </p>
                          <input
                            onChange={updateinfo}
                            name="channelName"
                            value={Channel.channelName}
                            type="text"
                            className="form-control my-4 "
                            placeholder="삭제할 채널 이름"
                            style={{
                              background: "#fcf4ff",
                              borderTop: "0",
                              borderRight: "0",
                              borderLeft: "0",
                              borderBottom: "1",
                              borderColor: "#d4cafb",
                              height: "38px",
                              width: "170px",
                              marginTop: "0px",
                              marginBottom: "0px",
                            }}
                          />
                        </div>
                        <div className="d-flex justify-content-evenly">
                          <button
                            onClick={DeleteChannel}
                            type="button"
                            className="col-2 p-1 btn btn-primary"
                          >
                            삭제
                          </button>
                          <button
                            type="submit"
                            className="col-2 p-1 btn btn-primary"
                            data-bs-dismiss="modal"
                          >
                            취소
                          </button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default ChannelSettingChange;
