import axios from "axios";

const getRoom = async (payload) => {
  const { data } = await axios.post(`/api/room/getRoom`,payload);
  return data;
};

const create = async (formData) => {
  const { data } = await axios.post("/api/room/create", formData);
  return data;
};

const join = async (payload) => {
  const { data } = await axios.put("/api/room/join", payload);
  return data;
};

const roomApi = { getRoom, create, join };

export default roomApi;
